REM ========================================================
REM   UWP Appx deliverable installation
REM ========================================================

@ECHO OFF
SET "Template=v1.07.cps"
SET "TARGETIMAGE="
if /i not "%~1" == "" if exist "%~1" SET "TARGETIMAGE=%~1"
if defined FCC_LOG_FOLDER (SET "APP_LOG_FOLDER=%FCC_LOG_FOLDER%") else ( if defined TARGETIMAGE (SET "APP_LOG_FOLDER=%TARGETIMAGE%\programdata\hp\logs") else (SET "APP_LOG_FOLDER=%~d0\programdata\hp\logs"))
SET "APP_LOG=%APP_LOG_FOLDER%\%~n0.log"
if not exist "%APP_LOG_FOLDER%" md "%APP_LOG_FOLDER%"

ECHO ############################################################# >> %APP_LOG%
ECHO  [%DATE%]                                                     >> %APP_LOG%
ECHO  [%TIME%] Beginning of the %~nx0, Ver: %Template%             >> %APP_LOG%
ECHO ############################################################# >> %APP_LOG%

REM ------------------- Script Entry ------------------------
:INSTALL
if not exist "%APP_LOG_FOLDER%\scratchdir" md "%APP_LOG_FOLDER%\scratchdir"
SET DISMCMD=%WINDIR%\System32\DISM.exe /Online /scratchdir:"%APP_LOG_FOLDER%\scratchdir" /LogPath:"%APP_LOG_FOLDER%\dism.log"
if defined TARGETIMAGE SET DISMCMD=%WINDIR%\System32\DISM.exe /image:"%TARGETIMAGE%" /scratchdir:"%APP_LOG_FOLDER%\scratchdir" /LogPath:"%APP_LOG_FOLDER%\dism.log"
SET "DISMCMD=%DISMCMD:\\=\%"

for /f "delims=" %%a in ('dir /ad /b "%~dp0"') do (
	echo [%TIME%] Search UWP Application in %~dp0%%~a >> %APP_LOG%
    call:UwpInst "%~dp0%%~a" >> %APP_LOG%
	if errorlevel 1 echo [%TIME%] Install failed. >> %APP_LOG% & goto RESULTFAILED
	echo [%TIME%] Install success. >> %APP_LOG%
)
if exist "%APP_LOG_FOLDER%\scratchdir" rd /q /s "%APP_LOG_FOLDER%\scratchdir"

if defined TARGETIMAGE GOTO END
if not exist "%~dp0setup_win32.cmd" GOTO END
echo [%TIME%] call "%~dp0setup_win32.cmd" >> %APP_LOG%
call "%~dp0setup_win32.cmd" >> %APP_LOG%
if not [%errorlevel%] == [0] echo setup_win32.cmd failed >> %APP_LOG% & GOTO RESULTFAILED
echo setup_win32.cmd success >> %APP_LOG%
GOTO END

:UwpInst
if not exist "%~1" echo could not found the path & exit /b 1
set Package=
set LicenseFile=
set DependencyPackages=

FOR /R "%~1" %%i in (*.*xbundle) DO (call set "Package=%%~i")
FOR /R "%~1" %%i in (*.xml) DO (call set "LicenseFile=%%~i")
FOR /R "%~1" %%i in (*_*__8wekyb3d8bbwe*) DO (call set DependencyPackages=%%DependencyPackages%% /DependencyPackagePath:"%%~i")
if not defined package for /f "delims=" %%i in ('dir /a-d /b %LicenseFile:~,-13%.*') DO (if exist "%~1\%%~i" call set "Package=%~1\%%~i")

if not defined Package echo Could not found the package & exit /b 1
if not defined LicenseFile echo Could not found license file & exit /b 1

SET "DISM_Command=/Add-ProvisionedAppxPackage /PackagePath:"%Package%" /Region="all" /LicensePath:"%LicenseFile%"%DependencyPackages%"

echo [%TIME%] %DISMCMD% %DISM_Command%
echo [%TIME%] %DISMCMD% %DISM_Command% >> %APP_LOG_FOLDER%\cmdline.txt
%DISMCMD% %DISM_Command%
if not errorlevel 1 echo [%TIME%] DISM command success & exit /b 0

FOR /F "delims=_" %%i in (%~1\AUMIDs.txt) do set DisplayName=%%i
if not defined DisplayName echo Could not found the DisplayName & exit /b 1
echo %DISMCMD% /get-provisionedappxpackages ^| find /i "%DisplayName%" 
%DISMCMD% /get-provisionedappxpackages | find /i "%DisplayName%"
if not errorlevel 1 echo Override previous error if a version of the appx is already installed & exit /b 0
echo [%TIME%] DISM command fail & exit /b 1
GOTO:EOF

:RESULTFAILED
ECHO ERRRORLEVEL=%ERRORLEVEL% >> %APP_LOG%
EXIT /B 1
GOTO END

:END
EXIT /B 0
